import numpy as np

def convert_audio_data( is_audio_signed, audio_bytes, number_of_audio_bits ):
    #convert audio data to meaningful units
    if is_audio_signed:
        audio_ints = np.array(audio_bytes).view(np.int16)
        min_value = -2 ** (number_of_audio_bits - 1) + 1
        max_value = 2 ** (number_of_audio_bits - 1)

    else:
        audio_ints = np.array(audio_bytes).view(np.uint16)
        min_value = 0
        max_value = 2 ** number_of_audio_bits
    range = max_value - min_value
    audio_data = (audio_ints - min_value) / float(range)
    return audio_data